;								EJEMPLO 29
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;Los mdulos CCPx. Modo de Captura, Medida de la duracin de un pulso.
;
;El ejemplo emplea el mdulo CCP1 y trata de capturar el valor del TMR1 cada vez que lleguen
;un flanco ascendente y otro descendente por la lnea RC2/CCP1. Conocida la velocidad a la 
;que evoluciona el TMR1, se puede determinar el lapsus de tiempo transcurrido entre ambos
;flancos, lo que nos dar la anchura del pulso.
;
		
		List	p=16F876A		;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos

;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

			__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC

Lcd_var		equ	0x20		;Variables para las rutinas de manejo del LCD
Byte_L		equ	0x22		;Parte baja del byte a convertir
Byte_H		equ	0x23		;Parte alta del byte a convertir
BCD_2		equ	0x24		;Byte 2 de conversin a BCD
BCD_1		equ	0x25		;Byte 1 de conversin a BCD
BCD_0		equ	0x26		;Byte 0 de conversin a BCD
Contador	equ	0x27		;Variable de contaje
Temporal	equ	0x28		;Variable temporal
Captura		equ	0x29		;N de capturas
Cap_1_L		equ	0x2a
Cap_1_H		equ	0x2b		;Variables temporales para las capturas

			org	0x00		;Vector de RESET	
			goto	Inicio
			org	0x04		;Vector de interrupcin
			goto	Inter
			org	0x05

		include	"LCD_CXX.INC"	;Incluye rutinas de manejo del LCD

;Visualizar: Visualiza sobre la pantalla LCD los cinco dgitos situados en las variables
;BCD_0, BC_1 y BCD_2

Visualizar	movlw	0x80
			call	LCD_REG		;Posiciona el cursor
			movlw	3
			movwf	Contador	;Inicia contador de bytes a convertir
			movlw	BCD_0
			movwf	FSR			;Inicia puntero ndice
Visual_loop	swapf	INDF,W
			andlw	0x0f
			iorlw	0x30		;Convierte a ASCII el nible de ms peso
			call	LCD_DATO	;Lo visualiza
			movf	INDF,W
			andlw	0x0f
			iorlw	0x30		;Convierte a ASCII el nible de menos peso
			call	LCD_DATO	;Lo visualiza
			decf	FSR,F		;Siguiente byte
			decfsz	Contador,F
			goto	Visual_loop
			movlw	' '
			call	LCD_DATO	;Visualiza espacio
			movlw	0xe4
			call	LCD_DATO	;Visualiza micro
			movlw	'S'
			call	LCD_DATO	;Visualiza 'S'
			return

;16Bits_BCD: Esta rutina convierte un nmero binario de 16 bits situado en Byte_H y
;Byte_L y, en 5 dgitos BCD que se depositan en las variables BCD_0, BCD_1 y BCD_2,
;siendo esta ltima la de menos peso.
;Est presentada en la nota de aplicacin AN544 de MICROCHIP y adaptada por Microsystems
;Engineering

Bits16_BCD	bcf		STATUS,C
			clrf	Contador	
			bsf		Contador,4	;Carga el contador con 16		
			clrf	BCD_0
			clrf	BCD_1
			clrf	BCD_2		;Puesta a 0 inicial

Loop_16		rlf		Byte_L,F
			rlf		Byte_H,F
			rlf		BCD_2,F
			rlf		BCD_1,F
			rlf		BCD_0,F		;Desplaza a izda. (multiplica por 2)
			decfsz	Contador,F
			goto	Ajuste
			return

Ajuste		movlw	BCD_2
			movwf	FSR			;Inicia el ndice
			call	Ajuste_BCD	;Ajusta el primer byte
			incf	FSR,F
			call	Ajuste_BCD	;Ajusta el segundo byte
			incf	FSR,F
			call	Ajuste_BCD
			goto	Loop_16

Ajuste_BCD	movf	INDF,W		
			addlw	0x03
			movwf	Temporal	
			btfsc	Temporal,3	;Mayor de 7 el nibble de menos peso ??
			movwf	INDF		;Si, lo acumula
			movf	INDF,W		
			addlw	0x30
			movwf	Temporal
			btfsc	Temporal,7	;Mayor de 7 el nibble de menos peso ??
			movwf	INDF		;Si, lo acumula
			return

;Programa de tratamiento de la interrupcin que provoca el mdulo CCP1 cada vez que se
;detecta, primero un flanco ascendente y luego un descendente por la lnea RC2/CCP1.

Inter		bcf		PIR1,CCP1IF	;Repone el flag del mdulo CCP1
			btfsc	Captura,0	;Es la captura del flanco descendente
			goto	Medir		;Si, medir el tiempo transcurrido entre ambas
			incf	Captura,F	;No, ha sido la captura del flanco ascendente
			movf	CCPR1L,W
			movwf	Cap_1_L
			movf	CCPR1H,W
			movwf	Cap_1_H		;Salvar, temporalmente, el 1er valor capturado
			bcf		CCP1CON,0	;Capturar al flanco descendente
			retfie

Medir		movf	Cap_1_L,W	;Es la captura del flanco descendente
			subwf	CCPR1L,W
			movwf	Byte_L
			btfss	STATUS,C
			incf	Cap_1_H,F
			movf	Cap_1_H,W
			subwf	CCPR1H,W
			movwf	Byte_H		;Restar el tiempo entre la 2 captura y la 1
			call	Bits16_BCD	;Convertir a BCD
			incf	Captura,F	;Capturar el 1er. flanco
			call	Visualizar	;Salida a pantalla LCD
			bsf		CCP1CON,0	;Captura al flanco ascendente
			retfie

;Programa principal

Inicio     	clrf	PORTB		;Desconecta salidas
			clrf	PORTA
			bsf		STATUS,RP0	;Selecciona banco 1
			movlw	b'00000110'
			movwf	ADCON1		;Puerta A E/S digitales
			clrf	TRISB		;Puerta B se configura como salida
			clrf	TRISA		;Puerta A salidas
			movlw	b'11111111'	
			movwf	TRISC		;Puerta C entrada
			bsf		PIE1,CCP1IE	;Habilita interrupcin del mdulo CCP1
			bcf		STATUS,RP0	;Selecciona banco 0	
			call	UP_LCD		;Configura puertos para el LCD
			call	LCD_INI		;Inicia el LCD
			movlw	b'00001100'
			call	LCD_REG		;LCD On, cursor y blink Off

;El TMR1 acta en el modo temporizador con reloj interno y un preescaler 1:8 evoluciona cada 8uS a 4MHz.
;Segn esto, el periodo mximo que se puede medir estar comprendido entre 0,5s (2Hz) y 8 uS (125 KHz) 
;aproximadamente. Para otros rangos se debe seleccionar un preescaler diferente.

			movlw	b'00110001'
			movwf	T1CON		;TMR1 en On, preescaler 1:8		
			movlw	b'11000000'
			movwf	INTCON		;Habilita interrupciones

;El mdulo CCP1 acta en modo de captura al flanco ascendente

			movlw	b'00000101'
			movwf	CCP1CON		;Mdulo CCP en On
			clrf	Captura		;Inicia captura en el 1er. flaco ascendente

Loop		nop
			goto	Loop		;Bucle infinito		

			end					;Fin del programa fuente
